import java.util.List;
import java.util.TreeMap;
import java.util.Collection;

class MovieRangeSearchLoesung {
  // BEACHTE: Diese Implementierung speichert nur einen Film pro Jahr !
  TreeMap<Integer, Movie> movies;

  // Konstruktor
  public MovieRangeSearchLoesung() {
    movies = new TreeMap<Integer, Movie>();
  }

  public void insertMovieForYear(int year, Movie movie) {
    movies.put(year, movie);
  }

  public Collection<Movie> getMoviesBetweenYears(int fromYear, int toYear) {
    return movies.subMap(fromYear, toYear).values();
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieRangeSearchLoesung movieSearch = new MovieRangeSearchLoesung();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieForYear(m.year, m);
    }

    // Bereichszugriff
    Collection<Movie> list = movieSearch.getMoviesBetweenYears(1950, 1959);

    // Ausgabe
    System.out.println("Filme zwischen 1950 und 1959:");
    for (Movie m : list) {
      System.out.println(m);
    }
  }
}
